/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

/* you have to decleare a static string for the window
  title 
*/

unsigned char test_title[] = "Bewegliche Feiertage";

/* you have to declare the event handlers BANKED and extern
*/

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);

/* define the command constants (belongs to a header file)
*/

int id=100;

#define cmdCompute 1000

/* define the main menu structure
*/

MENUITEM MainMenu[] =
{   {"Exit", cmCancel, 0},
    {"\0", 0, 0}
};

/* this is the definition of the drawing routine,
which is inserted for the main window with the
help of the BankedAssign() function.
*/

int topline;

char century,year;
typedef struct _Datum
{	int day;
	int month;
	int year;
} Datum;

Datum Eastern;

void computeEasternGregorian ()
{	int s,m,u,M,N,a,b,c,d,e;
	s=Eastern.year/100-Eastern.year/400-2;
	m=(Eastern.year-100*(Eastern.year/4200))/300-2;
	u=s-m;
	M=(15+u)%30; N=(6+s)%7;
	a=Eastern.year%19; b=Eastern.year%4; c=Eastern.year%7;
	d=(M+19*a)%30;
	e=(N+2*b+4*c+6*d)%7;
	if (d==29)
	{	d=28; e=(e+1)%7;
	}
	if (a>=11 && d==28)
	{	d=27; e=(e+1)%7;
	}
	Eastern.day=22+d+e;
	if (Eastern.day>31)
	{	Eastern.month=4;
		Eastern.day=Eastern.day-31;
	}
	else Eastern.month=3;
}

void computeEastern ()
{	Eastern.year=100*(int)century+year;
	computeEasternGregorian();
}

char * weekday[7]={"So","Mo","Di","Mi","Do","Fr","Sa"};

void write_date (_DATE *d, int x, int y)
{	unsigned char wd;
	wd=GetWeekDay(d);
	WriteString(x,y,weekday[wd],0);
	WriteDate(x+15,y,d,0);
}

void draw_results ()
{	int y=topline;
	int x=75;
	FillRect(10,topline,150,230,DRAW_WHITE);
	DrawRect(5,topline-5,155,235,DRAW_BLACK);
	SetFontType(PRPFONT7N);
	_DATE d,e,f;
	d.day=Eastern.day; d.month=Eastern.month; d.year=Eastern.year-1901;
	WriteString(10,y,"Neujahr",0);
	e.day=1; e.month=1; e.year=d.year;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"3 Knige",0);
	e.day=6; e.month=1; e.year=d.year;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Maifeiertag",0);
	e.day=1; e.month=5;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Fasching",0);
	AddDate(&e,&d,-47);
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Karfreitag",0);
	AddDate(&e,&d,-2);
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Ostermontag",0);
	AddDate(&e,&d,1);
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Chr. Himmelf.",0);
	AddDate(&e,&d,39);
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Pfingsten",0);
	AddDate(&e,&d,43);
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Fronleichnam",0);
	AddDate(&f,&e,10);
	write_date(&f,x,y);
	y+=9;
	WriteString(10,y,"Mar. Himmelf.",0);
	e.day=15; e.month=8;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Tag d. Einheit",0);
	e.day=3; e.month=10;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Allerheiligen",0);
	e.day=1; e.month=11;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"Bu u. Bettag",0);
	d.day=24; d.month=12;
	AddDate(&e,&d,-(int)GetWeekDay(&d));
	AddDate(&f,&e,-32);
	write_date(&f,x,y);
	y+=9;
	WriteString(10,y,"Heiligabend",0);
	e.day=24; e.month=12;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"1. Weihnachtsf.",0);
	e.day=25; e.month=12;
	write_date(&e,x,y);
	y+=9;
	WriteString(10,y,"2. Weihnachtsf.",0);
	e.day=26; e.month=12;
	write_date(&e,x,y);
	y+=9;
}

void test_draw (VOID_PTR view)
{   /* the pointer is really a point to a DESKBOX */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    PDESKBOX_draw(view); /* default, clears the view */

	draw_results();
}

/* the event handler for the menu commands and for
 the main window
*/

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
    if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {   case cmdCompute :
        		ClearEvent(evType);
        		computeEastern();
        		draw_results();
        		break;
        }
    }
}

short main (void)
{
    /* pointer to the main window (properly destroy it at end) */
    PDESKBOX *dsk;

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox(id++,0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);

	/* A number ticker for the year */
	_DATE date;
	GetDate(&date);
	PNUMBERSET *Year,*Century;
	int d=date.year+1901;
	century=d/100;
	year=d-century*100;
	Century=(PNUMBERSET *)CreateNumberSet(
		id++,20,30,19,20,1,&century);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Century);
	Year=(PNUMBERSET *)CreateNumberSet(
		id++,Century->right,30,0,99,1,&year);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Year);
	computeEastern();
	
	/* A button to recompute the year */
	PBUTTON *Compute;
	Compute=(PBUTTON *)CreateButton(
		id++,Year->right+10,30,Year->right+80,
		MK_FAR_PTR("Berechnen"),cmdCompute,bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Compute);
	
	topline=Century->bottom+15;

    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);
    
    return 0;
}
