/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

/* you have to decleare a static string for the window
  title 
*/

unsigned char test_title[] = "Deutsche Feiertage";

/* you have to declere the event handlers BANKED and extern
*/

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);

/* define the command constants (belongs to a header file)
*/

/* define the main menu structure
*/

const MENUITEM MainMenu[] =
{   {"Exit", cmCancel, 0},
    {"\0", 0, 0}
};

/* this is the definition of the drawing routine,
which is inserted for the main window with the
help of the BankedAssign() function.
*/

void test_draw (VOID_PTR view)
{   /* the pointer is really a point to a DESKBOX */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    PDESKBOX_draw(view); /* default, clears the view */

}

/* the event handler for the menu commands and for
 the main window
*/

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
    if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {   
        }
    }
}

short main (void)
{
    /* pointer to the main window (properly destroy it at end) */
    PDESKBOX *dsk;

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox('A',0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);

    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);
    
    return 0;
}
